; JFW 3.3 script file for Microsoft Internet Explorer
; Support for  IE5.x
; Copyright 1998, 1999  by Henter-Joyce, inc.
; Rewrote SelectALink script (8-11-99, GG)
; 
; 12/4/98. A.G. & GG
;updated and midified 03/26/99 by j.c

include "ie.jsh"
include "ie.jsm" ;added by KAG
include "hjconst.jsh"
include "hjglobal.jsh"
include "default.jsm"
use "magIE.jsb"

; *****
; The following section contains functions that either provide information about the version of IE which is running or
; work with both versions.
; *****

Function AutoStartEvent ()
let ieversion=2
Let nSuppressEcho = FALSE
EndFunction

Function AutoFinishEvent ()
RestrictCursor (off)
EndFunction

Function GetIEVersion ()
var
	string versionInfo,
	int period,
	string substring
let versionInfo = GetVersionInfoString (GetAppFilePath (), msgProductVersion)
let period = StringContains (versionInfo, msgDot)
if !period then
	if StringToInt (versionInfo) > 4 then
		return ie5
	elif
 StringToInt (versionInfo) > 3 then
		return ie5
	else
		return ie3
	EndIf
EndIf
let substring = SubString (versionInfo, 1, period-1)
if StringToInt (substring) <= 3 then
	return ie3
elif StringToInt (substring)  == 4 then
	let substring = SubString (versionInfo, period+1, 2)
	if (StringToInt (substring) > 70) then
		return ie5
	else
		return ie3
	EndIf
else
	return ie5
EndIf
EndFunction

Script ScriptFileName ()
	ScriptAndAppNames (msgIE5)
EndScript

Function SayNonHighlightedText (handle hwnd, string buffer)
var string TheClass
if IsPCCursor ()
then if (nSuppressEcho) then
	return
EndIf
let TheClass = GetWindowClass(hwnd)
if (TheClass == ie5Class) then
	if (GetWindowClass (GetFocus ()) == ie5Class) then
		if (globalMenuMode == menu_inactive) then
			if !CaretVisible () then
				Say(buffer, ot_buffer)
				return
			EndIf
		EndIf
	EndIf
EndIf
endif
if ((GetScreenEcho() > 1)
	|| (TheClass == DialogClass)) then
	Say(buffer, ot_buffer)
EndIf
EndFunction

Function SayHighlightedText (handle hwnd, string buffer)
var
	string theClass
let theClass = GetWindowClass(hwnd)
if (TheClass == ie5Class) then
	if (nSuppressEcho) then
		return
	EndIf
EndIf
SayHighlightedText (hwnd, buffer)
EndFunction

Function MoveToLink (int nNext)
; 1 = next, 0 = previous
if (nNext > 0) then
TabKey()
else
ShiftTabKey()
EndIf
let nSuppressEcho = true ; to avoid chattering caused by SayNonHighlightedText
If (MagGetState () > 0) then Return EndIf
pause ()
let nSuppressEcho = FALSE
EndFunction

Script MoveToNextLink()
MoveToLink(1)
EndScript

Script MoveToPriorLink ()
MoveToLink(0)
EndScript

Script SaySelectedLink ()
	SaySelectedLink4 ()
EndScript

Script GoBack ()
Let BackForward=1
{Alt + Left Arrow}
Say(msgBack, ot_message)
EndScript

Script GoForward ()
Let BackForward=1
{Alt + Right Arrow}
Say(msgForward, ot_message)
EndScript

Function FocusChangedEvent (handle focusWindow, handle prevWindow)
; The default FocusChangedEvent function has been modified to smooth going back and forth from the app 
; to the JAWS Select Item in List dialog
var
	handle RealWindow,
	string RealWindowName,
	handle AppWindow
let RealWindow = GetRealWindow(FocusWindow)
let RealWindowName = GetWindowName (RealWindow)
let AppWindow = GetAppMainWindow(FocusWindow)
if (GlobalPrevApp != AppWindow
   && AppWindow != FocusWindow) then 
	; we've switched to a different app main window, 
	; and it does not have the focus, so announce it
	; but first check that you are not moving between the app and the JAWS Select Item dialog
	if (GetWindowClass (globalPrevApp) == IEFrameClass &&
		GetWindowClass (appWindow) == IEFrameClass) then
		Say(msgNewBrowserWindow, ot_message)
	EndIf
	if (GetWindowClass (GlobalPrevApp) == wc_JAWS) then
		let GlobalFocusWindow = FocusWindow
		let GlobalPrevReal = RealWindow
		let GlobalPrevRealName = RealWindowName
		let GlobalPrevApp = AppWindow
		let GlobalPrevFocus = FocusWindow
		return
	EndIf
	if (GetWindowClass (appWindow) != wc_JAWS) then
		SayWindowTypeAndText(AppWindow)
	EndIf
endif
If ((GlobalPrevRealName != RealWindowName) ; name has changed
   || (GlobalPrevReal != RealWindow)) then ; or handle has changed, then
	If ((RealWindow != AppWindow)
	   && (RealWindow != FocusWindow)) then
		if ((GetWindowSubTypeCode (realWindow) == wt_dialog) &&
			StringContains (realWindowName, wnAlert)) then
			SayWindowTypeAndTextForNonstandardDialogs (realWindow, realWindowName)
		else
			SayWindowTypeAndText(RealWindow)
		EndIf
	endif
EndIf
;no matter what, say the window with focus
;but do it by calling a subroutine that can be special for each application, 
; for example, progman.jms
let GlobalFocusWindow = FocusWindow
if (GlobalPrevFocus != focusWindow) then
	SayFocusedWindow () ; will use global variable GlobalFocusWindow
else
	SayFocusedObject ()
EndIf
;above perform will return here to finish this routine
;now set all the global variables for next time.
let GlobalPrevReal = RealWindow
let GlobalPrevRealName = RealWindowName
let GlobalPrevApp = AppWindow
let GlobalPrevFocus = FocusWindow
EndFunction

Void Function SayFocusedWindow ()
var
	handle hwnd
if GetWindowClass (globalFocusWindow) != ie5Class then
	RestrictCursor (off)
EndIf
if (globalFocusWindow == GetNavigationTreeView ()) then
	let hwnd = GetParent (GetParent (GlobalFocusWindow))
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (hwnd)
	SayWord ()
	RestoreCursor ()
EndIf
SayFocusedObject ()
EndFunction

Script ReadCurrentScreen ()
if IsVirtualPCCursor ()
then Say (msg588, ot_string)
return
endif
MoveToWindow (GetFocus ())
RestrictCursor (on)
SayAll ()
EndScript

Script ReadNextScreen ()
let nSuppressEcho = TRUE
PCCursor ()
JawsPageDown ()
Delay (2)
let nSuppressEcho = FALSE
PerformScript ReadCurrentScreen()
EndScript

Script ReadPriorScreen ()
let nSuppressEcho = TRUE
PCCursor ()
JawsPageUp ()
Delay (2)
let nSuppressEcho = FALSE
PerformScript ReadCurrentScreen()
EndScript

Script AddressBar ()
var handle hwnd
let hwnd = FindDescendantWindow (GetAppMainWindow (GetFocus ()), address_bar4)
if (IsSameScript ()) then
	if (hwnd && IsWindowVisible (hwnd)) then
		JawsCursor()
		MoveToWindow (hwnd)
		if (GetChunk () != "") then
			Say(msgAddress + GetChunk(), ot_text)  
		else 
			Say(msgAddressBar, ot_message) 
		EndIf
	else 
		Say(msgAddressBarNotFound, ot_message) 
	EndIf
	Return
Else
	if (hwnd && IsWindowVisible (hwnd)) then
		; JawsCursor()
		SaveCursor ()
		InvisibleCursor ()
		MoveToWindow (hwnd)
		if (GetChunk () != "") then
			Say(msgAddress + GetChunk(), ot_text)  
		else 
			Say(msgAddressBar, ot_message) 
		EndIf
	else 
		Say(msgAddressBarNotFound, ot_message) 
	EndIf
	RestoreCursor ()
EndIf
EndScript

Script ReadDownColumn ()
if IsJAWSCursor () then
	NextLine ()
	SayChunk ()
else
	PerformScript ControlDownArrow()
EndIf
EndScript

Script ReadUpColumn ()
if IsJAWSCursor () then
	PriorLine ()
	SayChunk ()
else
	PerformScript ControlUpArrow()
EndIf
EndScript

Script ReadColumnLeft ()
if IsJAWSCursor () then
	PriorChunk ()
	;wn6="]"
	While (GetCharacter() == wn5) || (GetCharacter() ==wn6) 
		PriorChunk ()
	EndWhile
	SayChunk ()
else
	PerformScript SayPriorWord()
EndIf
EndScript

Script ReadColumnRight ()
if IsJAWSCursor () then
	NextChunk ()
	;wn6="]"
	while (GetCharacter() == wn5) || (GetCharacter() ==wn6) 
		NextChunk ()			
	EndWhile
	SayChunk()
else
	PerformScript SayNextWord()
Endif
EndScript

Script HotKeyHelp ()
var
	handle WinHandle,
	string TheClass
let WinHandle = GetFocus ()
let TheClass = GetWindowClass(WinHandle)
SayExtendedHelpHotKey ()
if ((TheClass == ie5Class) || 
	(GetWindowClass (GetParent (WinHandle)) == ie5Class)) then
	if (GetVerbosity () == beginner) then
		Say(msgHotKeys, ot_help)
	EndIf
	If (IsVirtualPcCursor ()) then
		VirtualHotKeyHelp ()
		Return
	EndIf
	Say(msgMoveThruLinks + 
	GetScriptKeyName ("MoveToNextLink") + msgAnd + 
	GetScriptKeyName ("MoveToPriorLink") + msgRespectively, ot_help)
	Say(msgReadLink + 
	GetScriptKeyName ("SaySelectedLink"), ot_help)
	Say(msgSelectALink +
	GetScriptKeyName ("SelectALink"), ot_help)
	If (!IsVirtualPcCursor ()) then
		Say(msgReformat +
	GetScriptKeyName ("ReformatDocument"), ot_help)
	EndIf
	Say(msgFirstField +
	GetScriptKeyName ("FocusToFirstField"), ot_help)
	Say(msgClickToolbarButton +
	GetScriptKeyName ("Toolbar"), ot_help)
	Say(msgCursorToAddressBar +
	GetScriptKeyName ("AddressBar"), ot_help)
	If (!IsVirtualPcCursor ()) then
		Say(msgReadBody +
		GetScriptKeyName ("ReadCurrentScreen"), ot_help)
		Say(msgReadThruWithJaws +
		GetScriptKeyName ("ReadPriorScreen") + msgAnd +
		GetScriptKeyName ("readNextScreen") + msgRespectively, ot_help)
	EndIf
	Say(msgReadColumns, ot_help)
	return
EndIf
HotKeyHelpDefaultLoop ()  ; standard dialog boxes
EndScript

Script ScreenSensitiveHelp ()
; Additions 09/10/1999, by D.B
; for support of the Virtual PC Cursor 
; namely new class and window types known to JFW w/ Virtual PC Cursor enabled
; This will not change performance when Virtual PC Cursor is not enabled
var
	int iWinType
if (IsSameScript ()) then
	AppFileTopic ()
	return
endif
If (GlobalMenuMode > 0) then
	PerformScript ScreenSensitiveHelp()
	Return
EndIf
let iWinType = GetWindowSubTypeCode (GetCurrentWindow ())
If (iWinType > 0) then
	ScreenSensitiveHelpForKnownClasses (iWinType)
	If (GetWindowClass (GetCurrentWindow ()) == IE5Class) then
		SayNumOfObjects ()
	EndIf
	Return
EndIf
if (ieVersion == ie5) then
	ScreenSensitiveHelp4 ()
else
	ScreenSensitiveHelp3 ()
EndIf
EndScript

; *****
; functions specifically written for ie5
; *****
Function SaySelectedLink4 ()
SayFocusedObject ()
EndFunction

HANDLE Function GetToolbar ()
var
	handle WinHandle
let WinHandle = FindDescendantWindow (GetAppMainWindow (GetFocus ()), tool_bar)
if (winHandle && 
	GetWindowClass (winHandle) == wc_toolbar) then
	return winHandle
EndIf
return 0
EndFunction



Function ClickToolBarButton (handle winHandle, string buttonLabel)
SaveCursor ()
JawsCursor ()
if FindString (winHandle, buttonLabel, s_top, s_restricted) then
	pause ()
	LeftMouseButton ()
else
	Say(buttonLabel + msgLabelNotFound, ot_control_name)
EndIf
EndFunction

Int Function FindString (handle hwnd, string str, int direction, int restriction)
; overrides the built-in FindString to handle searching for labels in the toolbar.
var
	int c,
	int x,
	int y
if ((GetControlId (hwnd) == tool_bar) &&
	(GetWindowSubTypeCode (hwnd) == wt_toolbar) && restriction) then
; the search is restricted to the IE toolbar, so search on your own!
	SaveCursor ()
	InvisibleCursor ()
	MoveToWindow (hwnd)
	RestrictCursor (off)
	while ((GetCurrentWindow () == hwnd) &&
		(c<20))
		if (GetWord () == str) then
			let x = GetCursorCol ()
			let y = GetCursorRow ()
			RestoreCursor ()
			JawsCursor ()
			MoveTo (x,y)
			return 1
		EndIf
		NextWord ()
		let c = c+1
	EndWhile
	return 0
else
	return FindString (hwnd, str, direction, restriction)
EndIf
EndFunction

Void Function VirtualHotKeyHelp ()
Say (msgHelp1 + GetScriptKeyName ("SelectALink"), OT_HELP); "For a List of all Links on this page"
Say (msgHelp2 + GetScriptKeyName ("SelectAFrame"), OT_HELP); For a List of Frames, press
Say (msgHelp3 + GetScriptKeyName ("ToolBar"), OT_HELP); "For a List of the tool bar buttons, press"
Say (msgHelp4 + GetScriptKeyName ("MoveToNextNonLinkText"), OT_HELP); "To move forward in the page past links, to a body of text, press"
Say (msgHelp5 + GetScriptKeyName ("RefreshScreen"), OT_HELP); "To update the screen view \r\n to the location of the Virtual Cursor \r\n press"
Say (msgHelp6 + GetScriptKeyName ("FocusToFirstField"), OT_HELP); "To jump to the first control on a form \r\n press"
Say (msgHelp7 + GetScriptKeyName ("AddressBar"), OT_HELP); "To have the U R L from the address line spoken \r\n press"
Say ((msgHelp8 + GetScriptKeyName ("AddressBar") + msgHelp9), OT_HELP); "To move the JAWS cursor to the address line \r\n press"
Say (msgHelp10 + GetScriptKeyName ("VirtualPcCursorToggle"), OT_HELP); "To toggle Virtual Cursor mode on or off press"
Say (msgHelp12 + GetScriptKeyName ("Enter"), OT_HELP); "Use Standard Screen reading commands to read the page"
Say (msgHelp13 + GetScriptKeyName ("PcCursor"), OT_HELP); To turn Virtual Cursor back on, press
Say (msgHelp14 + GetScriptKeyName ("ScreenSensitiveHelp"), OT_HELP); "For specific help at any time on this page press"
Say (msgHelp15 + GetScriptKeyName ("WindowKeysHelp"), OT_HELP); "For a list of Standard application keystrokes press"
EndFunction

Int Function SayNumOfObjects ()
var
	int iBool, ; return true or false
	object doc,
	object window,
	object forms,
	object frames,
	int nFrames,
	int nForms,
	int nLinks,
	string sFrameNum,
	string sLinkNum,
	string sFormNum,
	string szPageName,
	string strBuffer,
	string strTemp
let doc = ie4GetCurrentDocument ()
let window = doc.parentWindow
if doc then
	let frames = window.frames
	let nFrames = frames.length
	let nLinks = GetLinkCount ()
	let forms = doc.forms
	let nForms = forms.length
	if (nFrames > 0) then
		if (nFrames == 1) then
			let sFrameNum = IntToString (nFrames) + msgFrame
		else
			let sFrameNum = IntToString (nFrames) + msgFrames
		EndIf
	EndIf
	If (nLinks == 0) then
		let sLinkNum = msg0Links 
	EndIf
	If (nLinks > 0) then
		If (nLinks == 1) then
			let sLinkNum = IntToString (nLinks) + msgNumLink
		Else
			let sLinkNum = IntToString (nLinks) + msgNumLinks
		EndIf
	EndIf
	if (nForms > 0) then
		if nForms == 1 then
			let sFormNum = IntToString (nForms) + msgForm
		elIf (nForms > 1) then
			let sFormNum = IntToString (nForms) + msgForms
		EndIf
	EndIf
EndIf
If (StringLength (sFrameNum +sLinkNum +sFormNum) > 6) then
	let strBuffer = msgCurContains + msgNewLine
Else
	let strBuffer = ""
EndIf
If (nFrames > 0) then
	let strBuffer = strBuffer + sFrameNum + msgNewLine
EndIf
let strBuffer = strBuffer + sLinkNum + msgNewLine
If (nForms > 0) then
	let strBuffer = strBuffer + sFormNum
EndIf
if window then
	let strTemp = window.name
	if (strTemp == "") then
		let strTemp = window.location.href
	EndIf
EndIf
If (StringLength (StrTemp) > 0) then
	let szPageName = msgTitle + msgNewLine + strTemp
Else
	let szPageName = ""
EndIf
If (StringLength (strBuffer + szPageName) > 2) then ; not set to 0 in case of NewLine char
	If (StringLength (strBuffer) > 2) then
		Say ((strBuffer + msgNewLine), OT_HELP)
	EndIf
	If (StringLength (szPageName) > 2) then
		Say (szPageName, OT_HELP)
	EndIf
	let iBool = true
Else
	let iBool = false
EndIf
Return iBool
EndFunction

Void Function ScreenSensitiveHelp4 ()
var
	handle hwnd,
	String TheClass,
	object doc,
	object window,
	object forms,
	object frames,
	int nFrames,
	int nForms,
	string strBuffer,
	string strTemp
let hwnd = GetCurrentWindow ()
Let TheClass = GetWindowClass (hwnd)
if (TheClass == ie5Class) then
	Say (msgIEWindow, OT_HELP)
	SayNumOfObjects ()
	Say (msgHotKey + GetScriptKeyName ("HotKeyHelp"), OT_HELP)
	Return
EndIf
if IsLinksList (hwnd) then
	Say(msgLinksList, ot_help)
	Say(msgSelectLink, ot_help)
	Say(msgEnterToGo, ot_help)
	return
EndIf
if IsToolbarList (hwnd) then
	Say(msgButtonsList, ot_help)
	Say(msgSelectButton, ot_help)
	Say(msgEnterToClick, ot_help)
	return
EndIf
PerformScript ScreenSensitiveHelp ()
EndFunction

Int Function IsToolbarList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == ToolbarDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction

Int Function IsLinksList (handle hwnd)
if (GetWindowSubtypeCode (hwnd) == wt_listbox) then
	if (GetWindowClass (GetAppMainWindow (hwnd)) == wc_JAWS) then
		if (GetWindowName (GetRealWindow (hwnd)) == SelectALinkDialogName) then
			return 1;
		endIf
	EndIf
EndIf
return 0;
EndFunction





Function SayWindowTypeAndTextForNonstandardDialogs (handle hwnd, string name)
Say(name + msgDialog, ot_dialog_name)
let hwnd = GetFirstChild (hwnd)
while (hwnd)
	if (GetWindowSubTypeCode (hwnd) == wt_static) then
		Saywindow (hwnd, read_everything)
	EndIf
	let hwnd = GetNextWindow (hwnd)
EndWhile
EndFunction

HANDLE Function GetIEServerWindow (handle hwnd)
var
	handle hIEWindow
let hIEWindow = hwnd
while (hIEWindow)
	if (GetWindowClass (hIEWindow) == ie5Class) then
		return hIEWindow
	EndIf
	let hIEWindow = GetParent (hIEWindow)
EndWhile
let hIEWindow = GetFirstChild (GetAppMainWindow (hwnd))
while (hIEWindow && GetWindowClass (hIEWindow) != strShellView)
	let hIEWindow = GetNextWindow (hIEWindow)
EndWhile
let hIEWindow = GetFirstChild (hIEWindow)
while (hIEWindow && GetWindowClass (hIEWindow) != ie5Class)
	let hIEWindow = GetNextWindow (hIEWindow)
EndWhile
return hIEWindow
EndFunction

Script ReformatDocument ()
if IsVirtualPCCursor ()
then 	Say(MSG588, ot_message)
	return
EndIf
if (ieReformatBody (GetIEServerWindow (GetFocus ()))) then
	Say(msgReformattingPage, ot_message)
else
	Say(msgReformattingFailed, ot_message)
Endif
EndScript

Void Function SelectALink4 ()
var  object doc, object links, object all, int nLinks,
  string buffer, string strTemp, int nIdx
if (ieVersion == IE3) then Say(msgFeatureNotAvailable, ot_message) return EndIf
let doc = ie4GetCurrentDocument ()
let links = doc.links
let all = doc.all
let nLinks = links.length
if (nLinks == 0) then Say(msgNoLinks , ot_message) return endif
let nIdx = 0
while (nIdx < nLinks)
  let strTemp = links(nIdx).InnerText
  if (!strTemp) then let strTemp = all(links(nIdx).SourceIndex+1).alt endif
  if (!strTemp) then let strTemp = links(nIdx).href endif
  let buffer = buffer + "\007" + strTemp
  let nIdx = nIdx+1
endwhile
let nIdx = DlgSelectItemInList (buffer, SelectALinkDialogName, false)
if (nIdx == 0) then return endif
doc.links(nIdx-1).focus
doc.links(nIdx-1).click
EndFunction

Script SelectALink ()
If (! IsVirtualPcCursor ()) then
	SelectALink4 ()
	Return
EndIf
if (!DlgListOfLinks()) then
	Say(msgNoLinks , ot_message)
endif
EndScript


Int Function ieFocusToFirstField ()
var
	object doc,
	object all,
	object forms,
	int nIdx,
	object element,
	string theType
let doc = ie4GetCurrentDocument()
if (!doc) then
	return FALSE
endif
let forms = doc.forms
if (forms.length <= 0 ) then
	return FALSE
endif
let nIdx = forms(0).SourceIndex()
let all = doc.all
while (nIdx < all.length)
	let element = all(nIdx)
	let TheType = element.type
	if (TheType != "" &&
		TheType != msgHidden) then
		element.focus
		return TRUE
	endif
	let nIdx = nIdx+1
endwhile
return FALSE
EndFunction

Script ToolBar ()
var
	handle winHandle,
	int item
let winHandle = GetToolbar ()
if (!winHandle || !IsWindowVisible (winHandle)) then
	Say(msgToolBarNotFound, ot_message)
	return
EndIf
let item = dlgSelectItemInList (strToolbar, ToolbarDialogName, true)
let nSuppressEcho = true
delay (2)
if (item == Back) then
	ClickToolBarButton (winHandle, fsBack)
elif (item == Channels) then
	ClickToolBarButton (winHandle, fsChannels)
elif (item == Edit) then
	ClickToolBarButton (winHandle, fsEdit)
elif (item == Favorites) then
	ClickToolBarButton (winHandle, fsFavorites)
elif (item == Forward) then
	ClickToolBarButton (winHandle, fsForward)
elif (item == FullScreen) then
	ClickToolBarButton (winHandle, fsFullscreen)
elif (item == History) then
	ClickToolBarButton (winHandle, fsHistory)
elif (item == Home) then
	ClickToolBarButton (winHandle, fsHome)
elif (item == Mail) then
	ClickToolBarButton (winHandle, fsMail)
elif (item == Print) then
	ClickToolBarButton (winHandle, fsPrint)
elif (item == Refresh) then
	ClickToolBarButton (winHandle, fsRefresh)
elif (item == Search) then
	ClickToolBarButton (winHandle, fsSearch)
elif (item == Stop) then
	ClickToolBarButton (winHandle, fsStop)
EndIf
let nSuppressEcho = false
EndScript

Script FocusToFirstField ()
let nSuppressEcho = TRUE
if (ieFocusToFirstField()) then
	Beep()
	ProcessNewText()
else
	Say(msgFieldNotFound, ot_message)
Endif
let nSuppressEcho = FALSE
EndScript

HANDLE Function GetNavigationTreeView ()
var
	handle hwnd
let hwnd = FindDescendantWindow (GetAppMainWindow (GetFocus ()), navigation_treeview)
if (hwnd &&
	(GetWindowClass (hwnd) == wc_treeview) &&
	(GetWindowClass (GetParent (hwnd)) == wc_syspager)) then
	return hwnd
else
	return 0
EndIf
EndFunction

Void Function AddFramesInWindow (object window, string ByRef strBuf)
var
	object frames,
	int nFrames,
	int i,
	string strTemp
let frames = window.frames
let nFrames = frames.length
let i = 0
while (i<nFrames && i<10)
	let strTemp = frames(i).name
	if (strTemp == "") then
		let strTemp = frames(i).location.href
	EndIf
	let strBuf = strBuf + msgBellChar + strTemp
	let i = i+1
EndWhile
EndFunction

Object Function GetFrameInHierarchy (int index, object startWindow)
var
	object frames,
	int nFrames,
	int i,
	int j,
	object windows,
	int nWindows,
	object oNull
let frames = startWindow.frames
let nFrames = frames.length
if (index<=nFrames) then
	let i = 0
	while (i<nFrames)
		if (i==index-1) then
			return frames(i)
		EndIf
		let i = i+1
	EndWhile
else
	let index = index-nFrames
EndIf
let windows = startWindow.frames
let nWindows = windows.length
let j = 0
while (j<nWindows)
	let frames = windows(j).frames
	let nFrames = frames.length
	if (index<=nFrames) then
		let i = 0
		while (i<nFrames)
			if (i==index-1) then
				return frames(i)
			EndIf
			let i = i+1
		EndWhile
	else
		let index = index-nFrames
	EndIf
	let j = j+1
EndWhile
return oNull
EndFunction

int Function GetFrameNumber(object all,int nElement)
var
string strTag,
	int i,
int nFrame,
int nElements
let nFrame = 0
let nElements = all.length()
let i = 0
while (i< nElements)
let strTag = all(i).tagname
;make sure we don't match FrameSet as Frame
if (StringLength(strTag)== 5 && strTag == strFrame) then
if (i == nElement) then
return nFrame
EndIf
let nFrame = nFrame+1
EndIf
Let i = i+1
EndWhile
return 999
EndFunction
Function SpeakDocument (object doc)
var
int nElement,
int nFrame,
object all,
	object textRange
if !doc then
	let doc = ie4GetCurrentDocument ()
let nElement = ie4GetFocus()
let all = doc.all()
if (all(nElement).tagname == strFrame) then
let nFrame =  GetFrameNumber(all,nElement)
let doc = doc.Frames(nFrame).document()
EndIf
EndIf
let textRange = doc.body.createTextRange()
Say(textRange.text, ot_string)
EndFunction

Script SelectAFrame ()
var
	object doc,
	object topWindow,
	object windows,
	int nWindows,
	int i,
	string strBuf,
	int index,
	object frame
if (ieVersion == IE3) then
	Say(msgFeatureNotAvailable, ot_message)
	return
EndIf
let doc = ie4GetCurrentDocument ()
let topWindow = doc.parentWindow
let topWindow = topWindow.top
AddFramesInWindow (topWindow, strBuf)
let windows = topWindow.frames
let nWindows = windows.length
let i = 0
while (i<nWindows)
	AddFramesInWindow (windows(i), strBuf)
	let i = i+1
EndWhile
if (strBuf != "") then
	let index = DlgSelectItemInList (strBuf, SelectAFrameDialogName, false)
	if (index>0) then
		let frame = GetFrameInHierarchy (index, topWindow)
		if frame then
			frame.document.body.focus ()
			let nSuppressEcho = true
			delay (2)
			ActivateMenuBar ()
			ActivateMenuBar ()
;			PerformScript ReadCurrentScreen ()
			SpeakDocument (frame.document)
			let nSuppressEcho = false
		EndIf
	EndIf
else
	Say(msgNoFrames, ot_message)
EndIf
EndScript

Script NextFrame ()
var object null
if GetWindowClass (GetFocus ()) == ie5Class then
let nSuppressEcho = TRUE
EndIf
{control + tab}
delay (1)
if GetWindowClass (GetFocus ()) == ie5Class then
	SpeakDocument (null)
	;read the entire content of the new frame with focus
	let nSuppressEcho = FALSE
else
	if (IsMultiPageDialog ()) then
		Say(GetDialogPageName (), ot_dialog_name)
	EndIf
EndIf
let nSuppressEcho = FALSE
EndScript

Script PriorFrame ()
var object null
if GetWindowClass (GetFocus ()) == ie5Class then
let nSuppressEcho = TRUE
EndIf
{control + shift + tab}
delay (1)
if GetWindowClass (GetFocus ()) == ie5Class then
SpeakDocument (null) 
;read the entire content of the new frame with focus
let nSuppressEcho = FALSE
else
	if (IsMultiPageDialog ()) then
		Say(GetDialogPageName (), ot_dialog_name)
	EndIf
EndIf
EndScript
Script  JawsBackspace()
var
	int TheTypeCode
SaveCursor ()
PCCursor ()
let TheTypeCode = GetWindowSubtypeCode (GetCurrentWindow())
if IsVirtualPCCursor ()
then let BackForward=1
endif
If ((TheTypeCode == WT_TREEVIEW) || (TheTypeCode == WT_LISTVIEW)) then
  {backspace}
else
  RouteInvisibleToPc ()
  InvisibleCursor ()
  PriorCharacter ()
  SayCharacter ()
  {backspace}
endif
RestoreCursor ()
EndScript

Script IEFind ()
if IsVirtualPCCursor ()
then Say (msg586, ot_string) 
Say (msg587, ot_string) 
if JAWSFind () &&
IsVirtualPCCursor ()
 then SayLine ()
Return
 EndIf
 else {CTRL+f}
endif
EndScript

Script WindowKeysHelp ()
If (GetWindowClass (GetFocus ()) == IE5Class) then
	Say (msgHelp16 + GetScriptKeyName ("MoveToNextLink"), OT_HELP); "To move forward to the next link or control press"
	Say (msgHelp17 + GetScriptKeyName ("MoveToPriorLink"), OT_HELP); "To move backwards to the previous Link or control, press"
	Say (msgHelp18 + GetScriptKeyName ("Enter"), OT_HELP); "To activate a link, press"
	Say (msgHelp19 + GetScriptKeyName ("GoBack"), OT_HELP); "To move back to the previous page address you came from press"
	Say (msgHelp20 + GetScriptKeyName ("GoForward"), OT_HELP); "To move forward press"
	Say (msgHelp21, OT_HELP); "To move focus to the Address Bar press alt + d"
EndIf
PerformScript WindowKeysHelp ()
EndScript
